using System;
using Server;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class Firetooth : RepeatingCrossbow
	{
		public override int ArtifactRarity{ get{ return 75; } }

      public override int DefHitSound{ get{ return 0x223; } }		
  		public override int EffectID{ get{ return 0x2804; } }
//   		public override int EffectHue{ get{ return (this.Hue - 1); } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		public override int DefMaxRange{ get{ return 10; } }
		
		public override int AosStrengthReq{ get{ return 35; } }
		public override int AosMinDamage{ get{ return 20; } }
		public override int AosMaxDamage{ get{ return 23; } }
		public override int AosSpeed{ get{ return 45; } }		

		[Constructable]
		public Firetooth()
		{
			Hue = 2550;
			LootType = LootType.Blessed;
			Name = "<basefont color=#FF6600>Firetooth";
			Layer = Layer.TwoHanded;

			Attributes.WeaponDamage = 70;
			Attributes.AttackChance = 50;
			Attributes.BonusDex = 10;
			Attributes.RegenHits = 6;
			Attributes.RegenStam = 2;
			Attributes.DefendChance = 20;
			Attributes.Luck = 200;
			Attributes.WeaponSpeed = 30;
			WeaponAttributes.HitLeechHits = 60;
			WeaponAttributes.HitLeechMana = 60;
			WeaponAttributes.HitLeechStam = 60;
			WeaponAttributes.HitMagicArrow = 100;
			WeaponAttributes.HitFireball = 20;
			WeaponAttributes.HitHarm = 100;
			WeaponAttributes.SelfRepair = 3;
			WeaponAttributes.BattleLust = 1;
			
			SkillBonuses.SetValues( 0, SkillName.Archery, 15.0 );
			SkillBonuses.SetValues( 1, SkillName.Tactics, 10.0 );
		}
		
		public override void GetDamageTypes(Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy)
		{
			fire = 40; phys = 20; nrgy = 40; cold = pois = 0;
		}
		
		public override void DoFireball(Mobile attacker, Mobile defender)
		{
			if ( !attacker.CanBeHarmful(defender, false) || !attacker.Player )
				return;

			Ability.FlameSpray( 7, 50, attacker, false );
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#FF6600>Flame Spray Ability<basefont color=White>" );
		}

		public Firetooth( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( (int) 1 ); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
			
			if ( version == 0 )
			{
    			Attributes.WeaponDamage += 50;
    			Attributes.AttackChance += 10;
			   Attributes.RegenStam = 2;
    			WeaponAttributes.HitLeechHits = 60;
    			WeaponAttributes.HitLeechMana = 60;
    			WeaponAttributes.HitLeechStam = 60;
    			WeaponAttributes.HitMagicArrow = 100;
    			WeaponAttributes.HitHarm = 100;
    			MinDamage = 20;
    			MaxDamage = 23;
         }
		}
	}
}